C      *****************************************************************
C      * Subroutine TFSetUp                                            *
C      * Puts the nutrient throughfall concentrations in their places  *
C      * in the throughfall concentration array.                       *
C      *                                                               *
C      * Variables:                                                    *
C      * N         -Local - Array index.  Unitless.                    *
C      * NUTTFConc -Input - A vector, of size  NComp, of throughfall   *
C      *                    concentrations for all nutrients (species  *
C      *                    of interest).  Units are mol/L.            *
C      *                    (Common block VModel, file VModel.f)       *
C      * SpIndex   -Input - A vector, of size SpNum, of indices into   *
C      *                    arrays which match each species of         *
C      *                    interest.  SpIndex(i) is an index that when*
C      *                    used in the Labels array will give the     *
C      *                    name of the species amount the tree has    *
C      *                    consumed is NuTake(i).  SpIndex(i) when    *
C      *                    used as the index into SpConc will give the*
C      *                    concentration of this species.  Input from *
C      *                    TREGRO, or read into the model by the      *
C      *                    routine InParam.  Unitless.                *
C      *                    (Common block VIF, file VModel.f)          *
C      * SpNum     -Input - The number of species of interest.  Input  *
C      *                    from TREGRO, or read into the model by the *
C      *                    routine InParam.  Unitless.                *
C      *                    (Common block VIF, file VModel.f)          *
C      * TFConc    -Output- A vector, of size NComp, of throughfall    *
C      *                    concentrations.  The order of the          *
C      *                    components is the same as in SPConc.  Input*
C      *                    from TREGRO, or read into the model by the *
C      *                    routine InParam.  Units are mol/L.         *
C      *                    (Common block VModel, file VModel.f)       *
C      *****************************************************************
       SUBROUTINE TFSETUP
							IMPLICIT NONE
							INCLUDE 'VMODEL.INC'
							INTEGER N

C      *------------------------------------------------------------*
C      * Overwrite the current nutrient throughfall concentrations. *
C      *------------------------------------------------------------*
       DO 100 N = 1, SPNUM
          TFCONC(SPINDEX(N)) = NUTTFCONC(N)
  100  CONTINUE  

       RETURN
	      END
C      *****************************************************************
C      *                   END SUBROUTINE                              *
C      *****************************************************************
